//Source file: F:\jschwartz\src\Alkindi\BusinessServices\IClusterManager.java

/* Copyright (C) 2000 Alikindi, LLC */

package Alkindi.Services;

import Alkindi.Data.SystemUser;
import java.rmi.RemoteException;

/* 
$Header: IClusterManager.java, 10, 12/28/00 2:46:38 PM, Schwartz, Joe$
$Log: 
 10   Alkindi Development1.9         12/28/00 2:46:38 PM  Schwartz, Joe  
      Standardized methods to use final parameters and fully-qualified types
      where necessary. Makes Rose happy.
 9    Alkindi Development1.8         12/28/00 1:07:07 PM  Schwartz, Joe   Added
      Version Control header info.
 8    Alkindi Development1.7         12/26/00 6:57:11 PM  Schwartz, Joe   
 7    Alkindi Development1.6         12/18/00 12:05:35 PM Schwartz, Joe   Moved
      internal data classes to Utils package & regenerated classes from Rose.
 6    Alkindi Development1.5         10/30/00 7:53:13 PM  Schwartz, Joe   
 5    Alkindi Development1.4         10/19/00 1:12:03 PM  Schwartz, Joe   After
      10.19 Appian Delivery
 4    Alkindi Development1.3         10/9/00 3:12:11 PM   Schwartz, Joe   
 3    Alkindi Development1.2         10/6/00 4:13:36 PM   Schwartz, Joe   
 2    Alkindi Development1.1         9/24/00 3:12:15 PM   Schwartz, Joe   
 1    Alkindi Development1.0         9/21/00 4:12:04 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * This interface provides clustering services to the rest of the system.
 */
public interface IClusterManager 
{
	
	/**
	 * This assigns a given user to a cluster. Otherwise known as "Fast Clustering."
	 * @roseuid 39AE83C20232
	 */
	public void clusterUser(final Alkindi.Data.SystemUser user) throws RemoteException,AlkExcept;
	
	/**
	 * Recalculates statistics for the products for which ratings have been added since the last recalculation. This is to be performed on a schedule more frequently than regernateClusters.
	 * @roseuid 39C1617F02FD
	 */
	public void recalcProductStats() throws RemoteException,AlkExcept;
	
	/**
	 * Recalculates statistics for the all user clusters.
	 * @roseuid 39AC11E0003E
	 */
	public void recalcStats() throws RemoteException,AlkExcept;
	
	/**
	 * Generates or re-generates the user clusters for the entire system. This is called by a batch scheduler (like cron) at intervals: perhaps nightly at first, then more like weekly.
	 * @roseuid 39AECE290186
	 */
	public void regenerateClusters() throws RemoteException,AlkExcept;
	
	/**
	 * @roseuid 39F06D32004E
	 */
	public void initializeClusters() throws RemoteException,AlkExcept;
}
